<?php
/**
 * Module Name: BP Gallery Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'bp_gallplus_install' ) ) :

 //*************** Actions ***************\\
 add_action('gallery_media_upload_complete','my_bp_gallery_upload_add_cppoints');
 //*************** Detect Gallery Upload ***************\\
 function my_bp_gallery_upload_add_cppoints(){
  WPAchievements_Trigger::new_activity( array(
    'activity'    => 'cp_bp_galery_upload',
    'user_id'     => '',
    'post_id'     => '',
    'points'      => (int) wpachievements_get_site_option('wpachievements_bp_galery_upload'),
  ) );   
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_bpg_desc', 10, 4);
 function achievement_bpg_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'cp_bp_galery_upload': { $text = sprintf( _n( 'for uploading to a gallery %s time', 'for uploading to a gallery %s times', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_galery_delete': { $text = sprintf( _n( 'for deleting from a gallery %s time', 'for deleting from a gallery %s times', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_bpg_desc', 10, 3);
 function quest_bpg_desc($text='',$type='',$times=''){
  switch($type){
   case 'cp_bp_galery_upload': { $text = sprintf( _n( 'Upload to a gallery %s time', 'Upload to a gallery %s times', $times, 'wpachievements'), $times ); } break;
   case 'cp_bp_galery_delete': { $text = sprintf( _n( 'Delete from a gallery %s time', 'Delete from a gallery %s times', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_bpg' );
function wpachievements_add_section_bpg( $sections ) {
	$sections['bpg'] = __( 'BuddyPress Gallery', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_bpg_admin', 10, 3);
function wpachievements_bpg_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'bpg' ) {
    $settings[] = array( 'title' => __( 'BuddyPress Gallery', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'BuddyPressGallery_options' );

    $settings[] = array(
            'title'   => __( 'User Uploads Image', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the user uploads an image.', 'wpachievements' ),
            'id'      => $shortname.'_bp_galery_upload',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] =     array( 'type' => 'sectionend', 'id' => 'BuddyPressGallery_options');

    return $settings;
  /**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_bpg_admin_triggers', 1, 10);
 function achievement_bpg_admin_triggers($trigger){

   switch($trigger){
     case 'cp_bp_galery_upload': { $trigger = __('The user uploads to a gallery', 'wpachievements'); } break;
     case 'cp_bp_galery_delete': { $trigger = __('The user deletes from a gallery', 'wpachievements'); } break;
   }

   return $trigger;

 }

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_bpg_admin_events', 10);
 function achievement_bpg_admin_events(){
   echo'<optgroup label="BuddyPress Gallery Events">
     <option value="cp_bp_galery_upload">'.__('The user uploads to a gallery', 'wpachievements').'</option>
     <option value="cp_bp_galery_delete">'.__('The user deletes from a gallery', 'wpachievements').'</option>
   </optgroup>';
 }
endif;
?>